<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User;
use App\Models\Product;
use App\Enums\VerificationEnum;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\RefreshDatabase;

class UserSearchTest extends TestCase
{
    use RefreshDatabase, WithFaker;

    public function test_can_search_users_by_keyword()
    {
        $user = User::factory()->create();
        $product = Product::factory()->create();
        $product_id = $product->product_id;
        $key = $product->key;

        $this->actingAs($user, 'api');

        $user1 = User::factory()->create(['email' => 'john.doe@example.com']);
        $user2 = User::factory()->create(['username' => 'jane_public']);

        $response = $this->getJson('/api/users/search?keyword=doe', [
            'product' => $product_id,
            'product-key' => $key,
        ]);

        $response->assertJsonFragment([
            'email' => $user1->email,
        ]);

        $response->assertJsonMissing([
            'email' => $user2->email,
        ]);
    }

    public function testSearchByMultipleFilters()
    {
        $user = User::factory()->create();

        $product = Product::factory()->create();
        $product_id = $product->product_id;
        $key = $product->key;
        
        $this->actingAs($user, 'api');

        $user1 = User::factory()->create([
            'fname_en' => 'John',
            'lname_en' => 'Doe',
            'verification' => VerificationEnum::EMAIL->value,
        ]);

        $response = $this->getJson('/api/users/search', [
            'keyword' => 'John',
            'verification' => VerificationEnum::EMAIL->value,
            'product' => $product_id,
            'product-key' => $key,
        ]);

        $response->assertJsonFragment([
            'user_id' => $user1->user_id,
        ]);
    }
}
