<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User;
use App\Models\Product;
use Illuminate\Foundation\Testing\RefreshDatabase;

class GetUserTest extends TestCase
{
    use RefreshDatabase;

    public function testGetUserById()
    {
        $user = User::factory()->create();
        $product = Product::factory()->create();
        $product_id = $product->product_id;
        $key = $product->key;

        $this->actingAs($user, 'api');

        $response = $this->getJson('/api/users/' . $user->user_id, [
            'product' => $product_id,
            'product-key' => $key,
        ]);

        $response->assertStatus(200);

        $response->assertJsonFragment([
            'user_id' => $user->user_id,
        ]);
    }

    public function testUserNotFound()
    {
        $user = User::factory()->create();
        $product = Product::factory()->create();
        $product_id = $product->product_id;
        $key = $product->key;

        $this->actingAs($user, 'api');

        $response = $this->getJson('/api/users/999',  [
            'product' => $product_id,
            'product-key' => $key,
        ]);

        $response->assertStatus(404);
    }
}
