<?php

use App\Http\Controllers\User\SlinkController;
use App\Http\Controllers\User\UserController;
use Illuminate\Support\Facades\Route;


Route::prefix('/users')
    // ->middleware('auth:api')
    ->group(function () {
        Route::post('/generate-username', [UserController::class, 'generateUsername']);
        Route::post('/create-user', [UserController::class, 'createUser']);
        Route::get('/search', [UserController::class, 'search']);
        Route::post('/get-users', [UserController::class, 'getUsers']);
        Route::post('/set-cover', [UserController::class, 'setCover'])
            ->name('users.set-cover');
        Route::get('/covers', [UserController::class, 'getCovers'])
            ->name('users.covers');
        Route::post('/set-main-photo', [UserController::class, 'setMainPhoto'])
            ->name('users.set-main-photo');
        Route::get('/photos', [UserController::class, 'getPhotos'])
            ->name('users.photos');
        Route::get('/email/{email}', [UserController::class, 'getUserByEmail']);
        Route::get('/{user}/preferences', [UserController::class, 'getPreferences']);
        Route::put('/{user}/toggle-activation', [UserController::class, 'toggleActivation']);
        Route::get('/{user}/products', [UserController::class, 'getProducts']);
        Route::get('/{user}/images', [UserController::class, 'getUserImages']);
        Route::post('/{user}/images', [UserController::class, 'setUserImages']);
        Route::get('/{user}/slink', [SlinkController::class, 'getLinks']);
        Route::post('/{user}/slink', [SlinkController::class, 'saveLink']);
        Route::post('/{user}/delete-slink', [SlinkController::class, 'deleteLink']);
        Route::get('/{image}/delete-image', [UserController::class, 'deleteImage']);
        Route::post('/{image}/set-image', [UserController::class, 'SetImage']);
        Route::get('/{user}', [UserController::class, 'getUser']);
        Route::post('/{user}', [UserController::class, 'update']);
    });
