<!DOCTYPE html>
<html>

<head>
    <style>
        /* Define dynamic colors for header and footer */
        .header {
            background-color: {{ $headerColor }};
            color: #fff;
            padding: 20px;
        }

        .footer {
            background-color: {{ $footerColor }};
            color: #fff;
            padding: 20px;
        }

        /* Define email body styles */
        .email-body {
            padding: 20px;
            font-family: Arial, sans-serif;
        }

        .login-button {
            display: inline-block;
            background-color: {{ $headerColor }};
            color: #fff;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 4px;
        }
    </style>
</head>

<body>
<div class="header">
    <!-- Insert company logo or name here -->
    <img src="path/to/company-logo.png" alt="Company Logo" width="100" height="100">
    <h1>Company Name</h1>
</div>

<div class="email-body">
    <h2>Your Account Credentials</h2>

    <p>Dear {{ $userName }},</p>

    <p>Thank you for choosing our service. We are excited to have you on board!</p>

    <p>We are pleased to provide you with your account credentials:</p>

    <ul>
        <li>Email: {{ $userEmail }}</li>
        <li>Password: {{ $temporaryPassword }}</li>
    </ul>

    <p>We recommend logging in immediately to access your account and personalize your password for enhanced
        security.</p>

    <p>
        <a class="login-button" href="{{ $loginURL }}">Log In Now</a>
    </p>

    <p>If you have any questions or need assistance, please don't hesitate to contact us. We are here to help!</p>

    <p>Thank you again for choosing our service and for your trust in our company.</p>

    <p>Best regards,<br>{{ $companyRepresentative }}</p>
</div>

<div class="footer">
    <p>{{ __('Contact us:') }}</p>
    <p>
        {{ __('Website:') }} <a href="{{ $data['companyWebsite'] }}">
            {{ $data['companyWebsite'] }}
        </a>
    </p>
</div>
</body>

</html>
