<?php

namespace App\Notifications;

use App\Mail\VerifyEmail;
use Illuminate\Mail\Mailable;
use Illuminate\Bus\Queueable;
use App\Enums\VerificationEnum;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\VonageMessage;

class VerifyEmailNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public array $data;

    /**
     * Create a notification instance.
     *
     * @param  string  $token
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Get the notification's channels.
     *
     * @param  mixed  $notifiable
     * @return array|string
     */
    public function via($notifiable)
    {
        return $notifiable->verification == VerificationEnum::SMS
            ? ['vonage']
            : ['mail'];
    }

    public function toMail(object $notifiable): Mailable
    {
        return (new VerifyEmail($this->data))->to($notifiable->email);
    }

    public function toVonage(object $notifiable): VonageMessage
    {
        return (new VonageMessage)
            ->content(
                __(':verification_code is your verification code. It will expire in :expires_at minutes.', [
                    'verification_code' => $this->data['verification_code'],
                    'expires_at' => $this->data['verification_code_expires_at']->diffInMinutes(now()),
                ])
            );
        //->unicode();
    }
}
