<?php

namespace App\Notifications;

use App\Mail\ResetEmail;
use Illuminate\Mail\Mailable;
use Illuminate\Bus\Queueable;
use App\Enums\VerificationEnum;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\VonageMessage;

class ResetPasswordNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * The password reset token.
     *
     * @var string
     */
    public $token;

    public $data;

    /**
     * Create a notification instance.
     *
     * @param  string  $token
     * @return void
     */
    public function __construct($token, $data)
    {
        $this->token = $token;
        $this->data = $data;
    }

    /**
     * Get the notification's channels.
     *
     * @param  mixed  $notifiable
     * @return array|string
     */
    public function via($notifiable)
    {
        return $notifiable->verification == VerificationEnum::SMS
            ? ['vonage']
            : ['mail'];
    }

    public function toMail(object $notifiable): Mailable
    {
        $data = [
            'username' => $notifiable->username,
            'passwordResetURL' => url(route('auth.password-reset', [
                'token' => $this->token,
                'email' => $notifiable->getEmailForPasswordReset(),
            ], false)),
        ];

        $data = array_merge($data, $this->data);

        return (new ResetEmail($data))->to($notifiable->email);
    }

    public function toVonage(object $notifiable): VonageMessage
    {
        $url = url(route('auth.password-reset', [
            'token' => $this->token,
            'email' => $notifiable->getEmailForPasswordReset(),
        ], false));

        return (new VonageMessage)
            ->content($url);
        //->unicode();
    }
}
