<?php

namespace App\Models;

use App\Constants\UserConstants;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Image extends Model
{
    use HasFactory;

    public $primaryKey = 'img_id';

    public $timestamps = false;

    public $fillable = [
        'image',
        'user_id',
        'add_date',
        'type',
    ];

    public $casts = [
        'add_date' => 'datetime',
    ];

    public $appends = ['user_relation'];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }

    public function getUserRelationAttribute()
    {
        $relation = 0;
        if ($this->user->cover == $this->img_id) {
            $relation = UserConstants::IMAGE_TYPE_COVER;
        } else if ($this->user->image == $this->img_id) {
            $relation = UserConstants::IMAGE_TYPE_PROFILE;
        }
        return $relation;
    }
}
