<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Contracts\Queue\ShouldQueue;

class ResetEmail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $data = [];

    public $token;
    public $user;

    /**
     * Create a new message instance.
     */
    public function __construct($token, $data, $user)
    {
        $this->token = $token;
        $websiste = str_ends_with($data['companyDashboard'], '/') ? substr($data['companyDashboard'], 0, -1) : $data['companyWebsite'];

        $this->data = [
            'headerColor' => '#007bff',
            'footerColor' => '#007bff',
            'buttonColor' => '#007bff',
            'companyLogo' => env('SSO_DASHBOARD_BASE_URL') . '/storage/' . $data['companyLogo'],
            'companyName' => $data['companyName'],
            'companyAddress' => '123 Main St, City, State',
            'companyPhoneNumber' => '123-456-7890',
            'companyWebsite' => $data['companyWebsite'],
            'facebookURL' => 'https://www.facebook.com/example',
            'twitterURL' => 'https://www.twitter.com/example',
            'linkedinURL' => 'https://www.linkedin.com/company/example',
            'facebookIcon' => 'path/to/facebook-icon.png',
            'twitterIcon' => 'path/to/twitter-icon.png',
            'linkedinIcon' => 'path/to/linkedin-icon.png',
            'username' => $user->username,
            'passwordResetURL' => $websiste . '/admin/reset?email=' . $user->email . '&token=' . $token . '&lang=' . $data['lang']
        ];

        $data = array_merge($data, $this->data);
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: __('Reset Email'),
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'mail.reset',
            // view: 'mail.reset-password',
            with: [
                'data' => $this->data,
                'token' => $this->token,
                'user' => $this->user
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
