<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class CredentialsEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;
    /**
     * Create a new message instance.
     */
    public function __construct($data)
    {
        $this->data = $data;
        /*
    The code to use to fill data whenever sending a credentials email

    $data = [

    'headerColor' => '#007bff',
    'footerColor' => '#007bff',
    'buttonColor' => '#007bff',
    'companyLogo' => 'path/to/company-logo.png',
    'companyName' => 'Company Name',
    'userName' => 'John Doe',

    'userEmail' => 'user@gmail.com',
    'temporaryPassword' => 'password',
    'loginURL' => 'https://www.example.com/login',

    'companyAddress' => '123 Main St, City, State',
    'companyPhoneNumber' => '123-456-7890',
    'companyWebsite' => 'https://www.example.com',
    'facebookURL' => 'https://www.facebook.com/example',
    'twitterURL' => 'https://www.twitter.com/example',
    'linkedinURL' => 'https://www.linkedin.com/company/example',
    'facebookIcon' => 'path/to/facebook-icon.png',
    'twitterIcon' => 'path/to/twitter-icon.png',
    'linkedinIcon' => 'path/to/linkedin-icon.png',
    ];
     */
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Credentials Email',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'mail.credentials',
            with: [
                'data' => $this->data,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
