<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SlinkResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "user_id" => $this->user_id,
            "provider" => app()->getLocale() == 'ar' ? $this->provider->title : $this->provider->etitle,
            "link" => $this->link,
            "date" => $this->date,
        ];
    }
}
