<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;

class ImageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    // public function toArray(Request $request): array
    // {
    //     return [
    //         'img_id' => $this->img_id,
    //         'image' => url('storage' . $this->image),
    //         'type' => $this->type,
    //         'add_date' => $this->add_date,
    //         'user_relation' => $this->user_relation,
    //     ];
    // }
    public function toArray(Request $request): array
    {
        $relativePath = $this->image;
        $url = null;
    
        if ($relativePath) {
            $baseUrl = config('app.url');
    
            $relativePath = ltrim($relativePath, '/');
    
            $url = $baseUrl . '/storage/' . $relativePath;
        }
    
        return [
            'img_id' => $this->img_id,
            'image' => $url,
            'type' => $this->type,
            'add_date' => $this->add_date,
            'user_relation' => $this->user_relation,
        ];
    }
    
}
