<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use App\Constants\UserConstants;
use Illuminate\Foundation\Http\FormRequest;

class SetMainPhotoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'photo_id' => [
                'required_without:photo',
                'integer',
                Rule::exists('images', 'img_id')
                    ->where('user_id', $this->user()->user_id)
                    ->where('type', UserConstants::IMAGE_TYPE_PROFILE),
            ],
            'photo' => [
                'required_without:photo_id',
                'image',
                'max:1024',
            ],
        ];
    }
}
