<?php

namespace App\Http\Requests;

use App\Enums;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\Password;

class RegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'fname' => [
                'string'
            ],
            'lname' => [
                'string'
            ],
            'username' => [
                'required',
                'min:2',
                'max:64',
                'alpha_dash:ascii',
                Rule::unique('users', 'username'),
            ],
            'mobile' => [
                'nullable',
                'max:16',
                Rule::unique('users', 'mobile'),
            ],
            'email' => [
                'required',
                'max:320',
                Rule::unique('users', 'email')
                // ,
            ],
            'password' => [
                'required',
                'confirmed',
                Password::defaults(),
            ],
            'image' => [
                'nullable',
                'image',
                'max:1024',
            ],
            'cover' => [
                'nullable',
                'image',
                'max:1024',
            ],
            'gender' => [
                'nullable',
                Rule::enum(Enums\GenderEnum::class),
            ],
            'bdate' => [
                'nullable',
                'date',
            ],
            'verification' => [
                'nullable',
                'integer',
                Rule::enum(Enums\VerificationEnum::class),
            ],
            'city' => [
                'nullable',
            ]
        ];
    }
}
