<?php

namespace App\Http\Controllers\Data;

use App\Models\City;
use App\Models\Country;
use App\Services\LanguageService;
use App\Http\Controllers\Controller;
use App\Http\Resources\CityResource;
use App\Http\Resources\CountryResource;
use Illuminate\Http\Request;

class DataController extends Controller
{
    public function getCountries(Request $request)
    {
        if ($request->header('cities')) {
            $countries = Country::with('cities')->get();
        } else {
            $countries = Country::all();
        }
        return response()->json(['countries' => CountryResource::collection($countries)]);
    }

    public function getCities(Country $country)
    {
        $cities = $country->cities;
        return response()->json(['cities' => CityResource::collection($cities)]);
    }
    // get all cities
    public function getAllCities()
    {
        $cities = City::all();
        return response()->json(['cities' => CityResource::collection($cities)]);
    }

    public function getCountry(City $city)
    {
        $country = $city->country;
        return response()->json(['country' => $country]);
    }

    public function getCity(City $city)
    {
        return response()->json(['city' => $city]);
    }
}
